ORCA/M Asm65816 2.1.0

0001 D980              ;===============================================================================
0002 D980              ; e1_get_ref_num
0003 D980              ;               The REAL get_ref_num call
0004 D980              ;
0005 D980              ; Created       08/31/91
0006 D980              ; Author        GAB
0007 D980              ;
0008 D980              ; WARNING:  Assumes DBR is set to bank 0 on entry
0009 D980              ;
0010 D980              ;===============================================================================
0011 D980
0012 D980              e1_get_ref_num Proc 
0013 D980                       DataChk Off
0014 D980
0015 D980              msb_mask equ   s_temp1                  ;Temp equate.
0016 D980              character equ   s_temp2                 ;Temp equate.
0017 D980              fcr_ptr_temp equ   s_temp3              ;Temp equate.
0018 D980
0019 D980              ref_offset equ   $0006                  ;Offset to ref_num parm.
0020 D980              access_offset equ   $0008               ;Offset to access_parm
0021 D980              fork_offset equ   $000a                 ;Offset to form_num parm.
0022 D980              case_offset equ   $000c                 ;Offset to case_sense parm.
0023 D980              disp_offset equ   $000e                 ;Offset to displacement parm.
0024 D980
0025 D980              ; continuation of call (not enough room in bank 0)
0026 D980
0027 D980              *
0028 D980              * No error on translation.  Does the supplied pathname refer to ONLY one of the
0029 D980              * standard prefix numbers?  If so, simply return information about that I/O stream.
0030 D980              *
0031 D980 AD 21 B9              lda   std_prefix_num           ;is it one of the standard prefixes?
0032 D983 F0 1F                 beq   @not_std_pfx             ;no...
0033 D985 38                    sec                            ;yes, turn it into an index
0034 D986 E9 0A 00              sbc   #10
0035 D989 0A                    asl   a
0036 D98A AA                    tax   
0037 D98B BD 1B B9              lda   std_ref_num,x            ;get the std_ref_num
0038 D98E F0 06                 beq   @to_not_found            ;if 0, it's not open
0039 D990 22 72 F8 00           jsl   findfcr                  ;get a VP to the FCR
0040 D994 90 03                 bcc   @got_it
0041 D996              @to_not_found  
0042 D996 4C 6E DA              jmp   not_found
0043 D999              @got_it   
0044 D999 22 09 FE 00           jsl   deref2                   ;make a real pointer
0045 D99D 86 DC                 stx   <fcr_ptr_temp
0046 D99F 84 DE                 sty   <fcr_ptr_temp+2
0047 D9A1 4C 46 DA              jmp   get_output               ;go fill in the caller's parm block
0048 D9A4              @not_std_pfx  
0049 D9A4
0050 D9A4              *
0051 D9A4              * Is there a device name/number in the path? If so, exit with a bad_path_syntax error...
0052 D9A4              *
0053 D9A4 A9 40 00              lda   #bad_path_syntax         ;Assume error.
0054 D9A7 A6 36                 ldx   <dev1_num                ;Device number?
0055 D9A9 F0 03                 beq   @no_device               ;no...
0056 D9AB 4C 71 DA              jmp   error_exit               ;Yep, so exit with error.
0057 D9AE              @no_device  
0058 D9AE              *
0059 D9AE              * Ok, all of our parameters are valid.  Initialize fcr_index and found_count
0060 D9AE              * to control search...
0061 D9AE              *
0062 D9AE 9C 9A B9              stz   |fcr_index               ;Init fcr_index.
0063 D9B1 9C 9C B9              stz   |found_count             ;Init found_count.
0064 D9B4              *
0065 D9B4              * Here begins our main search loop.  Go find the next fcr and branch to
0066 D9B4              * no_more_fcrs if error...
0067 D9B4              *
0068 D9B4 C2 20        next_fcr rep   #m8                      ;Make sure we're in 16 bit mode.
0069 D9B6                       longa on
0070 D9B6
0071 D9B6 EE 9A B9              inc   |fcr_index               ;Bump current index.
0072 D9B9 AD 9A B9              lda   |fcr_index               ;Get it.
0073 D9BC 22 44 F9 00           jsl   getfcr                   ;Try to find it.
0074 D9C0 90 03                 bcc   do_deref                 ;No error.
0075 D9C2 4C 66 DA              jmp   no_more_fcrs             ;Error.
0076 D9C5
0077 D9C5 22 09 FE 00  do_deref jsl   deref2                   ;Deref VP.
0078 D9C9 86 DC                 stx   <fcr_ptr_temp            ;Save pointer.
0079 D9CB 84 DE                 sty   <fcr_ptr_temp+2
0080 D9CD              *
0081 D9CD              * Check to make sure this FCR is for the fork we're interested in.  If not,
0082 D9CD              * branch to next_fcr...
0083 D9CD              *
0084 D9CD A0 14 00              ldy   #fcr_access              ;Get offset to access word.
0085 D9D0 B7 DC                 lda   [<fcr_ptr_temp],y        ;Get access.
0086 D9D2 29 00 40              and   #%0100000000000000       ;Isolate fork bit.
0087 D9D5 18                    clc   
0088 D9D6 2A                    rol   a                        ;Shift to bit 0.
0089 D9D7 2A                    rol   a
0090 D9D8 2A                    rol   a
0091 D9D9 CD 94 B9              cmp   |fork_num                ;Is it what we want?
0092 D9DC D0 D6                 bne   next_fcr                 ;Nope.
0093 D9DE              *
0094 D9DE              * Now get FST id out of FCR and use it to look up the translation flags in
0095 D9DE              * the FST header.  Use the flags to set msb_mask so will clear msb's if
0096 D9DE              * needed...
0097 D9DE              *
0098 D9DE A0 06 00              ldy   #fcr_fst_id              ;Get offset to fst id.
0099 D9E1 B7 DC                 lda   [<fcr_ptr_temp],y        ;Get id.
0100 D9E3 22 68 E2 00           jsl   find_fst2                ;Go find it.
0101 D9E7 B0 CB                 bcs   next_fcr                 ;Skip it if error.
0102 D9E9 A8                    tay                            ;Put offset in Y.
0103 D9EA
0104 D9EA A2 FF FF              ldx   #%1111111111111111       ;Init mask to no change.
0105 D9ED
0106 D9ED B9 1F B8              lda   |fst_tbl+s_flags,y       ;Get flags word from FST header
0107 D9F0 29 00 10              and   #%0001000000000000       ;Want msb's cleared?
0108 D9F3 F0 03                 beq   set_msb_mask             ;Nope, so leave mask alone.
0109 D9F5 A2 7F FF              ldx   #%1111111101111111       ;Yes so get new mask.
0110 D9F8                                                      ; (we will be in 8 bit mode)
0111 D9F8
0112 D9F8 86 D4        set_msb_mask stx   <msb_mask            ;Save our mask.
0113 D9FA              *
0114 D9FA              * Get a pointer to the name in the FCR...
0115 D9FA              *
0116 D9FA A0 02 00              ldy   #fcr_path_name           ;Get offset to name VP.
0117 D9FD B7 DC                 lda   [<fcr_ptr_temp],y        ;Get VP low.
0118 D9FF AA                    tax                            ;Save it.
0119 DA00 C8                    iny   
0120 DA01 C8                    iny   
0121 DA02 B7 DC                 lda   [<fcr_ptr_temp],y        ;Get VP high.
0122 DA04 A8                    tay                            ;Put in Y.
0123 DA05 22 09 FE 00           jsl   deref2                   ;Dereference it.
0124 DA09 86 3E                 stx   <path2_ptr               ;Save in path2_ptr.
0125 DA0B 84 40                 sty   <path2_ptr+2
0126 DA0D              *
0127 DA0D              * Ok, so now path1_ptr points to source path and path2_ptr points to path in
0128 DA0D              * FCR.  Do the string compare.  If we don't match, branch to next_fcr...
0129 DA0D              *
0130 DA0D A7 3A                 lda   [<path1_ptr]             ;Get source length.
0131 DA0F C7 3E                 cmp   [<path2_ptr]             ;Match?
0132 DA11 D0 A1                 bne   next_fcr                 ;Nope, so do next FCR.
0133 DA13 A8                    tay                            ;Yes, use as index.
0134 DA14 C8                    iny                            ;Point past length word.
0135 DA15
0136 DA15 E2 20                 sep   #m8                      ;Go to 8 bit A.
0137 DA17                       longa off
0138 DA17
0139 DA17 B7 3A        match_loop lda   [<path1_ptr],y         ;Get source char.
0140 DA19 25 D4                 and   <msb_mask                ;Mask msb.
0141 DA1B 85 D8                 sta   <character               ;Save it.
0142 DA1D B7 3E                 lda   [<path2_ptr],y           ;Get dest char.
0143 DA1F 25 D4                 and   <msb_mask                ;Mask msb.
0144 DA21 C9 61                 cmp   #'a'                     ;Is lower case?
0145 DA23 90 07                 bcc   check_match              ;Nope.
0146 DA25 C9 7B                 cmp   #'z'+1
0147 DA27 B0 03                 bcs   check_match
0148 DA29 2D 92 B9              and   |case_mask2              ;Yes, so apply mask.
0149 DA2C C5 D8        check_match cmp   <character            ;Do we have a match?
0150 DA2E D0 84                 bne   next_fcr                 ;Nope, so next FCR.
0151 DA30 88                    dey                            ;Yes, back up one char.
0152 DA31 C0 01 00              cpy   #0001                    ;Done all?
0153 DA34 D0 E1                 bne   match_loop               ;No, so loop.
0154 DA36
0155 DA36 C2 20                 rep   #m8                      ;Yes, go back to 16 bit mode.
0156 DA38                       longa on
0157 DA38              *
0158 DA38              * We have a match, so bump the found_count.  If found_count = displacement
0159 DA38              * then we've got the one we want so grab the ref_num and access from the FCR
0160 DA38              * and fall thru to found, else go to next_fcr...
0161 DA38              *
0162 DA38 EE 9C B9              inc   |found_count             ;Bump count.
0163 DA3B AD 9C B9              lda   |found_count             ;Get it.
0164 DA3E CD 98 B9              cmp   |displacement            ;Equal displacement?
0165 DA41 F0 03                 beq   get_output               ;Yes.
0166 DA43 4C B4 D9              jmp   next_fcr                 ;Nope, so next_fcr.
0167 DA46
0168 DA46 A0 14 00     get_output ldy   #fcr_access            ;Get offset to access word.
0169 DA49 B7 DC                 lda   [<fcr_ptr_temp],y        ;Get access.
0170 DA4B 29 03 00              and   #%0000000000000011       ;Isolate access bits.
0171 DA4E AA                    tax                            ;Put in x.
0172 DA4F
0173 DA4F A7 DC                 lda   [<fcr_ptr_temp]          ;Get ref_num.
0174 DA51              *
0175 DA51              * We've found the one we're looking for and the ref_num is in A and the
0176 DA51              * access word is in X.  Stuff them in the parameter list and exit with carry
0177 DA51              * clear...
0178 DA51              *
0179 DA51 A0 06 00     found    ldy   #ref_offset              ;Get offset to ref_num.
0180 DA54 97 32                 sta   [<param_blk_ptr],y       ;Stuff it.
0181 DA56 A7 32                 lda   [<param_blk_ptr]         ;Get pcount.
0182 DA58 C9 02 00              cmp   #2                       ;Want access?
0183 DA5B F0 06                 beq   skip_access              ;Nope.
0184 DA5D
0185 DA5D A0 08 00              ldy   #access_offset           ;Yes, get offset to access.
0186 DA60 8A                    txa                            ;Get access in A.
0187 DA61 97 32                 sta   [<param_blk_ptr],y       ;Stuff it.
0188 DA63 18           skip_access clc                         ;Indicate no error.
0189 DA64 80 0C                 bra   release_exit             ;Exit.
0190 DA66              *
0191 DA66              * We've gone thru all of the FCRs.  This is an error condition except when
0192 DA66              * the displacement is zero, in which case we return the found_count in the
0193 DA66              * ref_num parm...
0194 DA66              *
0195 DA66 AD 9C B9     no_more_fcrs lda   |found_count         ;Get found_count just in case.
0196 DA69 AE 98 B9              ldx   |displacement            ;Requested count?
0197 DA6C F0 E3                 beq   found                    ;Yep, so return count.
0198 DA6E
0199 DA6E A9 60 00     not_found lda   #data_unavail           ;Nope, so return error.
0200 DA71 38           error_exit sec                          ;Indicate error.
0201 DA72
0202 DA72 6B           release_exit rtl                        ;back to bank 0 to exit
0203 DA73
0204 DA73                       DataChk On
0205 DA73                       end_proc 
0206 DA73
0207 DA73                       eject 
0208 DA73              ;===============================================================================
0209 DA73              ; fe_xlate      Perform special pathname translation for the format and erase
0210 DA73              ;               system calls.
0211 DA73              ;
0212 DA73              ; Created:      1/26/88
0213 DA73              ; Modified:
0214 DA73              ; Author:       JJ
0215 DA73              ;
0216 DA73              ; Enter:        jsl     fe_xlate
0217 DA73              ;
0218 DA73              ; Input:        A = fst flags to be used to control pathname translation
0219 DA73              ;               X = pass number through this routine
0220 DA73              ;               P = nvmxdizc
0221 DA73              ;                   ..000...
0222 DA73              ;
0223 DA73              ; Output:
0224 DA73              ;               A = if c=0, undefined; if c=1, error code
0225 DA73              ;               X = trashed
0226 DA73              ;               Y = trashed
0227 DA73              ;               P = nvmxdizc
0228 DA73              ;                   ..000..|
0229 DA73              ;                          =0 translation OK
0230 DA73              ;                          =1 error during translation
0231 DA73              ;
0232 DA73              ; Moved to bank $E1 to free up some room in bank $00, since it's only used by
0233 DA73              ; do_type_7 (format & erase).  Assumes DBR is set to correct value to access
0234 DA73              ; misc_data. (GAB)
0235 DA73              ;
0236 DA73              ;===============================================================================
0237 DA73
0238 DA73              fe_xlate proc 
0239 DA73                       datachk off
0240 DA73
0241 DA73              pblk_fe_dev equ   0                     ;offset of ptr to device name
0242 DA73              pblk_fe_volume equ   4                  ;offset of ptr to volume name
0243 DA73              pblk_fe_fst_id equ   8                  ;offset of fst_id field in class 0 pblk
0244 DA73
0245 DA73              ; Set up fst_flags for pathname translation.
0246 DA73
0247 DA73 8D 19 B9              sta   |fst_flags
0248 DA76 8A                    txa                            ;save pass number
0249 DA77 8F EC DA E1           sta   >pass_num
0250 DA7B
0251 DA7B              ; Prepare to translate the device name and volume name.
0252 DA7B
0253 DA7B 22 96 E2 00           jsl   init_path_vars2          ;Initialize pathname variables.
0254 DA7F
0255 DA7F              ; Translate device name.
0256 DA7F
0257 DA7F A9 00 00              lda   #pblk_fe_dev             ;get offset to device name ptr in pblk
0258 DA82 18                    clc   
0259 DA83 6D A2 B9              adc   |class
0260 DA86
0261 DA86 22 82 E0 00           jsl   call_xlate_path          ;translate the path
0262 DA8A B0 5E                 bcs   relay_error
0263 DA8C
0264 DA8C              ; Check that the input path is just a device name and nothing more.
0265 DA8C
0266 DA8C A5 36                 lda   <dev1_num                ;is there a valid device number?
0267 DA8E F0 57                 beq   bad_path_err             ;no, invalid pathname syntax
0268 DA90
0269 DA90 A5 42                 lda   <path_flag               ;is there anything after device name?
0270 DA92 29 00 40              and   #$4000
0271 DA95 D0 50                 bne   bad_path_err             ;yes, bad path error
0272 DA97
0273 DA97              ; The device name parameter was OK.  Translate the volume parameter.
0274 DA97              ; Note:  fst_flags still has the correct value.
0275 DA97
0276 DA97 EE AE B9              inc   |xlate_count             ;indicate that this is second pathname
0277 DA9A
0278 DA9A AF EC DA E1           lda   >pass_num                ;is this pass 0 or 1?
0279 DA9E F0 10                 beq   @pass0                   ;pass 0, null pathname pointer allowed
0280 DAA0 AD C2 B9              lda   volname_ptr              ;else get pointer from SCM's variable
0281 DAA3 85 D4                 sta   <in_ptr
0282 DAA5 AD C4 B9              lda   volname_ptr+2
0283 DAA8 85 D6                 sta   <in_ptr+2
0284 DAAA 22 86 E0 00           jsl   call_xlate3              ;do the pathname translation
0285 DAAE 80 2D                 bra   @common_xlate            ;then enter common code
0286 DAB0
0287 DAB0              @pass0    
0288 DAB0 A9 04 00              lda   #pblk_fe_volume          ;get offset to volume name ptr in pblk
0289 DAB3 18                    clc   
0290 DAB4 6D A2 B9              adc   |class
0291 DAB7
0292 DAB7 A8                    tay                            ;use Y as index
0293 DAB8 AA                    tax                            ;and save index in X for a bit
0294 DAB9 AD A2 B9              lda   |class                   ;is there a pCount?
0295 DABC F0 07                 beq   @no_pCount               ;no, volume name MUST be supplied
0296 DABE A7 32                 lda   [<param_blk_ptr]         ;get the pCount
0297 DAC0 C9 02 00              cmp   #$0002                   ;is the volume name supplied?
0298 DAC3 90 21                 bcc   outta_here               ;nope!
0299 DAC5              @no_pCount  
0300 DAC5 18                    clc                            ;in case of NULL volume name string
0301 DAC6 B7 32                 lda   [<param_blk_ptr],y       ;get the volume name pointer
0302 DAC8 85 D4                 sta   in_ptr                   ;store here
0303 DACA C8                    iny   
0304 DACB C8                    iny   
0305 DACC B7 32                 lda   [<param_blk_ptr],y       ;get high word
0306 DACE 85 D6                 sta   in_ptr+2
0307 DAD0 05 D4                 ora   in_ptr                   ;is it NULL?
0308 DAD2 F0 12                 beq   outta_here               ;yes, no volume name supplied
0309 DAD4 A7 D4                 lda   [in_ptr]                 ;get the length
0310 DAD6 F0 0E                 beq   outta_here               ;null string...
0311 DAD8 8A                    txa                            ;else put index back into Acc
0312 DAD9 22 82 E0 00           jsl   call_xlate_path          ;then translate the path
0313 DADD              @common_xlate  
0314 DADD B0 0B                 bcs   relay_error
0315 DADF
0316 DADF              ; Check that the translated pathname consists of a volume name and nothing else.
0317 DADF
0318 DADF A6 3E                 ldx   <path2_ptr               ;set up pointer to translated path
0319 DAE1 A4 40                 ldy   <path2_ptr+2
0320 DAE3 20 EE DA              jsr   is_volume_only           ;check that pathname is only a volume
0321 DAE6              *	bcs	relay_error	;relay the bad_path_syntax error code
0322 DAE6              outta_here  
0323 DAE6 6B                    rtl                            ;return with no error
0324 DAE7
0325 DAE7              bad_path_err  
0326 DAE7 A9 40 00              lda   #bad_path_syntax
0327 DAEA              relay_error  
0328 DAEA 38                    sec   
0329 DAEB 6B                    rtl   
0330 DAEC
0331 DAEC 00 00        pass_num DS W:1
0332 DAEE
0333 DAEE                       datachk on
0334 DAEE                       end_proc 
0335 DAEE
0336 DAEE                       eject 
0337 DAEE              ;===============================================================================
0338 DAEE              ; is_volume_only
0339 DAEE              ;
0340 DAEE              ; Determines whether or not a specified pathname consists of exactly a
0341 DAEE              ; separator followed by a syntactically correct volume name and nothing more.
0342 DAEE              ;
0343 DAEE              ; Note:         Use this routine only on pathnames that have already been
0344 DAEE              ;               translated and determined to be syntactically correct by
0345 DAEE              ;               xlate_path.
0346 DAEE              ;
0347 DAEE              ; Enter:        jsr     is_volume_only
0348 DAEE              ;
0349 DAEE              ; Input:        X = low word of pointer to the internal pathname string
0350 DAEE              ;               Y = high word of pointer to the internal pathname string
0351 DAEE              ;               P = nvmxdizc
0352 DAEE              ;                   ..000...
0353 DAEE              ;
0354 DAEE              ; Output:       A = if c=0, undefined
0355 DAEE              ;                   if c=1, bad_path_syntax error code
0356 DAEE              ;               X = trashed
0357 DAEE              ;               Y = trashed
0358 DAEE              ;               P = nvmxdizc
0359 DAEE              ;                   ..000..|
0360 DAEE              ;                          0=no error
0361 DAEE              ;                          1=error
0362 DAEE              ;===============================================================================
0363 DAEE
0364 DAEE              is_volume_only proc 
0365 DAEE
0366 DAEE              string_ptr equ   s_temp1
0367 DAEE              string_length equ   s_temp2
0368 DAEE
0369 DAEE              ; String pointer must be non-null.
0370 DAEE
0371 DAEE 8A                    txa                            ;set condition codes
0372 DAEF D0 03                 bne   ok_1
0373 DAF1 98                    tya   
0374 DAF2 F0 2D                 beq   syntax_error
0375 DAF4              ok_1      
0376 DAF4
0377 DAF4 86 D4                 stx   <string_ptr              ;set up string pointer on direct page
0378 DAF6 84 D6                 sty   <string_ptr+2
0379 DAF8
0380 DAF8              ; String length must be at least 2.
0381 DAF8
0382 DAF8 A7 D4                 lda   [<string_ptr]            ;get string length
0383 DAFA C9 02 00              cmp   #2
0384 DAFD 90 22                 blt   syntax_error
0385 DAFF
0386 DAFF              ; Prepare to look at each character in the string.
0387 DAFF
0388 DAFF A0 02 00              ldy   #$0002                   ;offset of first character
0389 DB02
0390 DB02 E2 20                 sep   #m8                      ;enter 8-bit m mode
0391 DB04                       longa off
0392 DB04
0393 DB04 B7 D4                 lda   [<string_ptr],y          ;get first character
0394 DB06 C9 3A                 cmp   #sep                     ;is it the separator
0395 DB08 D0 15                 bne   syntax_error1            ;no, syntax error
0396 DB0A
0397 DB0A C8           loop     iny                            ;increment index
0398 DB0B B7 D4                 lda   [<string_ptr],y          ;get next character
0399 DB0D F0 0C                 beq   end_string               ;string is terminated with a $00
0400 DB0F C9 3A                 cmp   #sep                     ;is it a separator?
0401 DB11 D0 F7                 bne   loop                     ;no, go on
0402 DB13
0403 DB13                       longa on
0404 DB13
0405 DB13 C2 20        sep_in_string rep   #m16                ;yes, may be an error
0406 DB15 98                    tya                            ;offset at which sep was found
0407 DB16 3A                    dec   a                        ;adjust for comparison
0408 DB17 C7 D4                 cmp   [<string_ptr]            ;compare to string length
0409 DB19 D0 06                 bne   syntax_error
0410 DB1B
0411 DB1B C2 20        end_string rep   #m16
0412 DB1D 18                    clc                            ;normal return
0413 DB1E 60                    rts   
0414 DB1F
0415 DB1F C2 20        syntax_error1 rep   #m16                ;back to 16-bit m mode
0416 DB21 A9 40 00     syntax_error lda   #bad_path_syntax
0417 DB24 38                    sec   
0418 DB25 60                    rts   
0419 DB26
0420 DB26                       end_proc 
0421 DB26
0422 DB26                       eject 
0423 DB26              ;===============================================================================
0424 DB26              ; do_drvr_status - performs a driver status call
0425 DB26              ;
0426 DB26              ; located here 'cause there's not enough room in bank $00
0427 DB26              ;
0428 DB26              ; Assumes DBR is set to $00, and Direct Page is set to GS/OS direct page
0429 DB26              ;
0430 DB26              ; On Entry:     Acc = driver device #
0431 DB26              ;===============================================================================
0432 DB26
0433 DB26                       DataChk Off
0434 DB26              do_drvr_status Proc 
0435 DB26
0436 DB26 85 00                 sta   <drvr_dev_num            ;store the passed device number
0437 DB28
0438 DB28 A9 05 00              lda   #drvr_status             ;call # for Status call
0439 DB2B 85 02                 sta   <drvr_call_num
0440 DB2D A9 DC B9              lda   #dev_status              ;use this as the status list
0441 DB30 85 04                 sta   <drvr_slist_ptr
0442 DB32 A9 00 00              lda   #^dev_status
0443 DB35 85 06                 sta   <drvr_slist_ptr+2
0444 DB37 A9 02 00              lda   #2                       ;only need 2 bytes
0445 DB3A 85 08                 sta   <drvr_req_cnt
0446 DB3C 64 16                 stz   <drvr_stat_code          ;requesting device status
0447 DB3E 22 00 FC 01           jsl   dev_dispatcher           ;make the call (this also set's up drvr_dib_ptr)
0448 DB42 60                    rts   
0449 DB43                       End_proc 
0450 DB43                       DataChk On
0451 DB43
0452 DB43                       eject 
0453 DB43              ;===============================================================================
0454 DB43              ; e1_volume_call - handles new parameters to the Volume call
0455 DB43              ;
0456 DB43              ; located here 'cause there's not enough room in bank $00
0457 DB43              ;
0458 DB43              ; Assumes DBR is set to $00
0459 DB43              ;
0460 DB43              ;===============================================================================
0461 DB43
0462 DB43              e1_volume_call Proc 
0463 DB43                       DataChk Off
0464 DB43
0465 DB43 08                    php                            ;save carry
0466 DB44 90 0B                 bcc   @no_error                ;skip if no error occurred
0467 DB46 AE 15 B9              ldx   |curr_fst                ;get FST table offset to FST that handled call
0468 DB49 BD 1D B8              lda   |fst_tbl+id,x            ;get the FST ID
0469 DB4C A0 12 00              ldy   #$0012                   ;offset in parameter block of FST ID
0470 DB4F 97 32                 sta   [<param_blk_ptr],y       ;store the ID
0471 DB51
0472 DB51              @no_error  
0473 DB51
0474 DB51              ; now we make a status call to the driver to get the current write-protect status
0475 DB51
0476 DB51 A5 36                 lda   <dev_num                 ;get the device number
0477 DB53 20 26 DB              jsr   do_drvr_status           ;make the driver status call
0478 DB56
0479 DB56 A7 32                 lda   [<param_blk_ptr]         ;get the pCount again
0480 DB58 C9 08 00              cmp   #$0008                   ;did caller ask for device ID?
0481 DB5B 90 0A                 bcc   just_chars               ;no, just the characteristics
0482 DB5D A0 34 00              ldy   #dev_id_num              ;else get the ID number from the DIB
0483 DB60 B7 20                 lda   [<drvr_dib_ptr],y
0484 DB62 A0 18 00              ldy   #$0018                   ;store into parmblock
0485 DB65 97 32                 sta   [<param_blk_ptr],y
0486 DB67
0487 DB67              just_chars  
0488 DB67 AD 19 B9              lda   |fst_flags               ;get the flags of the FST that handled call
0489 DB6A EB                    xba                            ;put Read-Only bit into low byte
0490 DB6B 29 08 00              and   #%00001000               ;mask to just read-only bit
0491 DB6E 4A                    lsr   a                        ;shift to correct bit position
0492 DB6F 4A                    lsr   a
0493 DB70 4A                    lsr   a
0494 DB71 48                    pha                            ;save on stack for a minute
0495 DB72 A0 08 00              ldy   #dev_char                ;offset to device characteristics
0496 DB75 B7 20                 lda   [<drvr_dib_ptr],y
0497 DB77 29 EC FF              and   #%1111111111101100       ;clear low two bits and "open files" bit
0498 DB7A 03 01                 ora   1,s                      ;combine with FST read-only bit
0499 DB7C 83 01                 sta   1,s                      ;and leave on stack
0500 DB7E AD DC B9              lda   dev_status               ;this is where Status call put status word
0501 DB81 29 04 00              and   #%00000100               ;only interested in write-protect status
0502 DB84 4A                    lsr   a                        ;shift to correct bit position
0503 DB85 03 01                 ora   1,s                      ;combine with previous bits
0504 DB87 83 01                 sta   1,s                      ;and put back on stack
0505 DB89 A3 03                 lda   3,s                      ;retrieve saved carry bit
0506 DB8B 29 01 00              and   #$0001                   ;was the carry set on entry?
0507 DB8E D0 47                 bne   @no_open_files           ;yes, skip the open-files check
0508 DB90
0509 DB90 A0 06 00              ldy   #6                       ;get the returned volume name
0510 DB93 B7 32                 lda   [<param_blk_ptr],y
0511 DB95 1A                    inc   a                        ;bump past buffer size word
0512 DB96 1A                    inc   a
0513 DB97 85 EC                 sta   <m_temp                  ;store as source pointer
0514 DB99 C8                    iny   
0515 DB9A C8                    iny   
0516 DB9B B7 32                 lda   [<param_blk_ptr],y
0517 DB9D 85 EE                 sta   <m_temp+2
0518 DB9F A9 60 B9              lda   #device_name             ;destination of copy
0519 DBA2 85 E8                 sta   <ptr
0520 DBA4 A9 00 00              lda   #^device_name
0521 DBA7 85 EA                 sta   <ptr+2
0522 DBA9 22 18 B7 00           jsl   to_copy_string           ;copy the string to our local buffer
0523 DBAD AD 60 B9              lda   device_name              decrease length by 1 to remove leading colon
0524 DBB0 3A                    dec   a
0525 DBB1 8D 61 B9              sta   device_name+1
0526 DBB4 A2 61 B9              ldx   #device_name+1
0527 DBB7 A0 00 00              ldy   #^(device_name+1)
0528 DBBA A9 00 00              lda   #0                       ;look for a name
0529 DBBD 22 63 F8 00           jsl   FindVcrCase              ;look for the VCR
0530 DBC1 22 38 FC 01           jsl   DeRef                    ;deref the returned VP
0531 DBC5 86 F8                 stx   vcr                      ;save the pointer
0532 DBC7 84 FA                 sty   vcr+2
0533 DBC9 A0 08 00              ldy   #vcr_open_cnt            ;get the count of open files
0534 DBCC B7 F8                 lda   [<vcr],y
0535 DBCE F0 07                 beq   @no_open_files           ;no open files
0536 DBD0 A9 10 00              lda   #$0010                   ;else set bit 4 of the characteristics
0537 DBD3 03 01                 ora   1,s
0538 DBD5 83 01                 sta   1,s
0539 DBD7              @no_open_files  
0540 DBD7 68                    pla                            ;retrieve final characteristics
0541 DBD8 A0 16 00              ldy   #$0016                   ;offset in parmblock
0542 DBDB 97 32                 sta   [<param_blk_ptr],y       ;store the characteristics
0543 DBDD 28                    plp                            ;retrieve original status
0544 DBDE 6B                    rtl   
0545 DBDF
0546 DBDF                       DataChk On
0547 DBDF                       end_proc 
0548 DBDF
0549 DBDF                       eject 
0550 DBDF              ;===============================================================================
0551 DBDF              ; FST Table Management Routines
0552 DBDF              ;
0553 DBDF              ; Relocated from bank $00 to bank $E1 to free up some room in bank $00 (GAB)
0554 DBDF              ;
0555 DBDF              ;===============================================================================
0556 DBDF
0557 DBDF              fst_tbl_mgr proc 
0558 DBDF                       entry add_fst
0559 DBDF
0560 DBDF                       longa on
0561 DBDF                       longi on
0562 DBDF                       DataChk off
0563 DBDF
0564 DBDF              ;===============================================================================
0565 DBDF              ; add_fst:      Add a new FST to the FST Table immediately after the last entry.
0566 DBDF              ;
0567 DBDF              ; Created:      4/9/87
0568 DBDF              ; Modified:     1/18/89
0569 DBDF              ; Author:       JJ
0570 DBDF              ;
0571 DBDF              ; Enter:        jsl     add_fst
0572 DBDF              ;
0573 DBDF              ; Input:        X = low word of pointer to an FST header
0574 DBDF              ;               Y = high word of pointer to an FST header
0575 DBDF              ;               P = nvmxdizc
0576 DBDF              ;                   ..000...
0577 DBDF              ;
0578 DBDF              ; Output:       A = if c=0, undefined; if c=1, error code
0579 DBDF              ;                 = 0001 - FST Table is full
0580 DBDF              ;                 = 0002 - input object does not look like an FST
0581 DBDF              ;                 = 0003 - FST error occured during initialization call
0582 DBDF              ;               X = trashed
0583 DBDF              ;               Y = trashed
0584 DBDF              ;               P = nvmxdizc
0585 DBDF              ;                   ..000..|
0586 DBDF              ;                          0=no error, 1=error
0587 DBDF              ;===============================================================================
0588 DBDF
0589 DBDF              file_sys_id equ   $0c                   ;Offset to FST id in header.
0590 DBDF              copy_length equ   $22                   ;Offset to word before name len.
0591 DBDF              high_sierra_id equ   $0b                ;ID for High Sierra FST.
0592 DBDF              iso_9660_id equ  $0c                    ;ID for ISO 9660 FST.
0593 DBDF
0594 DBDF              add_fst   
0595 DBDF
0596 DBDF              *
0597 DBDF              * Are we looking at an FST header?
0598 DBDF              *
0599 DBDF 8B                    phb                            ;save user's DBR and set ours to PBR
0600 DBE0 F4 B8 00              pea   fst_count>>8             ;set DBR to bank containing variables
0601 DBE3 AB                    plb   
0602 DBE4 AB                    plb   
0603 DBE5
0604 DBE5 86 D4                 stx   <s_temp1                 ;temp1 <-- pointer to FST header
0605 DBE7 84 D6                 sty   <s_temp1+2
0606 DBE9
0607 DBE9 A7 D4                 lda   [<s_temp1]               ;check that what we're looking at looks
0608 DBEB C9 46 53              cmp   #'SF'                    ;... like an FST header, i.e. the first
0609 DBEE D0 08                 bne   error_hop                ;... four bytes are 'FST '
0610 DBF0 A0 02 00              ldy   #2
0611 DBF3 B7 D4                 lda   [<s_temp1],y
0612 DBF5 C9 54 20              cmp   #' T'
0613 DBF8              error_hop  
0614 DBF8 D0 7E                 bne   not_fst_header
0615 DBFA
0616 DBFA              *
0617 DBFA              * Yes, is it High Sierra/ISO 9660?  If so, set hs_fst_flag.  We set this flag
0618 DBFA              * so that get_fst_info can fake an entry for ISO 9660.  This is necessary because
0619 DBFA              * the FST supports BOTH file systems and has only one ID in its header.  In order
0620 DBFA              * to keep our local copy current, we also copy the header up to the FST name...
0621 DBFA              *
0622 DBFA A0 0C 00     is_fst_header ldy   #file_sys_id        ;Get offset to file system id.
0623 DBFD B7 D4                 lda   [<s_temp1],y             ;Get id.
0624 DBFF C9 0B 00              cmp   #high_sierra_id          ;Is high sierra?
0625 DC02 D0 15                 bne   check_space              ;Nope.
0626 DC04 EE 25 B9              inc   hs_fst_flag              ;Yep, so set flag.
0627 DC07
0628 DC07 A0 22 00              ldy   #copy_length             ;Get length to copy (even #).
0629 DC0A B7 D4        copy_header lda   [<s_temp1],y          ;Get word.
0630 DC0C 99 27 B9              sta   iso_fst_header,y         ;Update our header.
0631 DC0F 88                    dey                            ;Done all?
0632 DC10 88                    dey   
0633 DC11 10 F7                 bpl   copy_header              ;Nope, so loop.
0634 DC13
0635 DC13 A9 0C 00              lda   #iso_9660_id             ;Yes, restore ISO 9660 id.
0636 DC16 8D 33 B9              sta   iso_fst_id
0637 DC19              *
0638 DC19              * Do we have space for another FST?
0639 DC19              *
0640 DC19 AD 0F B8     check_space lda   |fst_count            ;is there any space in the table?
0641 DC1C C9 10 00              cmp   #max_fsts
0642 DC1F B0 57                 bge   fst_table_full           ;no, report error
0643 DC21              *
0644 DC21              * Yep, call the FST's initialization function and exit if error...
0645 DC21              *
0646 DC21 A0 08 00              ldy   #sys_entry               ;offset of system entry point addr
0647 DC24 B7 D4                 lda   [<s_temp1],y             ;get low word of address
0648 DC26 8F 36 DC E1           sta   >jump_vector+1           ;store address into code
0649 DC2A C8                    iny   
0650 DC2B B7 D4                 lda   [<s_temp1],y             ;get middle word of address
0651 DC2D 8F 37 DC E1           sta   >jump_vector+2           ;store into code
0652 DC31
0653 DC31 8B                    phb                            ;save our DBR
0654 DC32 A2 02 00              ldx   #init_fst                ;indicate init FST call
0655 DC35 22 54 AC 02  jump_vector jsl   >$000000              ;this instruction is modified by code
0656 DC39                                                      ;above.
0657 DC39
0658 DC39 AB                    plb                            ;Restore data bank.
0659 DC3A B0 3F                 bcs   fst_init_error           ;Error so don't add to table.
0660 DC3C              *
0661 DC3C              * No error, so add fst entry to table...
0662 DC3C              *
0663 DC3C
0664 DC3C AD 0F B8              lda   |fst_count               ;Get current count.
0665 DC3F EE 0F B8              inc   |fst_count               ;increment the number of active entries
0666 DC42
0667 DC42 0A                    asl   a                        ;multiply original number of entries
0668 DC43 0A                    asl   a                        ;... (still in A) by 16 to get offset to
0669 DC44 0A                    asl   a                        ;... first unused record
0670 DC45 0A                    asl   a
0671 DC46 AA                    tax                            ;move to X to use as offset into table
0672 DC47
0673 DC47 A0 0C 00              ldy   #id                      ;test to see if this is the ProDOS FST
0674 DC4A B7 D4                 lda   [<s_temp1],y             ;get the FST id
0675 DC4C 3A                    dec   a                        ;check to see if it is ProDOS (FST id=1)
0676 DC4D D0 03                 bne   ar1                      ;no, do nothing
0677 DC4F 8E 11 B9              stx   |prodos_index            ;yes, save index to this table entry
0678 DC52 C9 08 00     ar1      cmp   #8                       ; is it the char fst? (id = 9-1)
0679 DC55 D0 03                 bne   ar2
0680 DC57 8E 13 B9              stx   |char_index
0681 DC5A
0682 DC5A A5 D4        ar2      lda   <s_temp1                 ;save pointer to FST header in FST Tbl
0683 DC5C 9D 11 B8              sta   |fst_tbl+fst_hdr_ptr,x
0684 DC5F A5 D6                 lda   <s_temp1+2
0685 DC61 9D 13 B8              sta   |fst_tbl+fst_hdr_ptr+2,x
0686 DC64
0687 DC64 A0 04 00              ldy   #app_entry               ;copy app_entry, sys_entry, id and flags
0688 DC67 B7 D4        loop2    lda   [<s_temp1],y             ;... from FST header into FST Table
0689 DC69 9D 15 B8              sta   |fst_tbl+app_entry,x
0690 DC6C C8                    iny   
0691 DC6D C8                    iny   
0692 DC6E E8                    inx   
0693 DC6F E8                    inx   
0694 DC70 C0 10 00              cpy   #s_flags+2
0695 DC73 90 F2                 blt   loop2
0696 DC75
0697 DC75 18                    clc                            ;indicate no error
0698 DC76 AB                    plb                            ;restore caller's DBR
0699 DC77 6B                    rtl   
0700 DC78
0701 DC78              fst_table_full  
0702 DC78 A9 02 00     not_fst_header lda   #fst_load_fail     	;not an FST error
0703 DC7B              *	bra	error_tail
0704 DC7B
0705 DC7B              fst_init_error                          ;error occurred during FST init call
0706 DC7B                                                      ;so report it's error.
0707 DC7B
0708 DC7B 38           error_tail sec                          ;indicate error
0709 DC7C AB                    plb                            ;restore caller's DBR
0710 DC7D 6B                    rtl   
0711 DC7E
0712 DC7E                       DataChk On
0713 DC7E                       end_proc 
0714 DC7E
0715 DC7E                       eject 
0716 DC7E              ;======================================================================
0717 DC7E              ; get_id : Gets an ID for use with the system memory manager
0718 DC7E              ;
0719 DC7E              ; Created:      April 22, 1987
0720 DC7E              ; Modified:     July 20, 1987
0721 DC7E              ; Author:       Mike Askins
0722 DC7E              ;
0723 DC7E              ; Copyright Apple Computer Inc. 1987  All rights reserved
0724 DC7E              ;
0725 DC7E              ; Input:        A = undefined
0726 DC7E              ;               X = undefined
0727 DC7E              ;               Y = undefined
0728 DC7E              ;               P = nvmxdizc
0729 DC7E              ;                   ..000...
0730 DC7E              ;
0731 DC7E              ; Output:       A = ID
0732 DC7E              ;               X = trashed
0733 DC7E              ;               Y = trashed
0734 DC7E              ;               P = nvmxdizc
0735 DC7E              ;                   ..000...
0736 DC7E              ;               b = preserved
0737 DC7E              ;         gsos_id = the ID
0738 DC7E              ;
0739 DC7E              ;======================================================================
0740 DC7E                       DataChk Off
0741 DC7E              get_mm_id proc 
0742 DC7E
0743 DC7E F4 00 00              pea   $0000                    ;Push the space for result
0744 DC81 F4 00 31              pea   mm_id_tag                ;Tag field
0745 DC84              *
0746 DC84 A2 03 20 22           _GetNewID                      ;Get an ID from Misc Tools
0747 DC8B 68                    pla   
0748 DC8C 8F E2 B9 00           sta   >gsos_id
0749 DC90 6B                    rtl   
0750 DC91
0751 DC91                       end_proc 
0752 DC91                       DataChk On
0753 DC91
0754 DC91                       EJECT 
0755 DC91              *******************************************************************************
0756 DC91              *
0757 DC91              *        Name:  loader_rename
0758 DC91              *
0759 DC91              * Description:  Takes translated pathnames from change_path call and does
0760 DC91              *               insert_vol_name on both, then uses the results to make the
0761 DC91              *               loader rename call.
0762 DC91              *
0763 DC91              *      Author:  Bryan Atsatt
0764 DC91              *     Created:  May 16, 1989
0765 DC91              *    Modified:  Jan 23, 1992
0766 DC91              *       {GAB}   When the original pathname was specified as ONLY a device name,
0767 DC91              *               meaning that the volume name was being changed, the
0768 DC91              *               insert_vol_name call was occurring AFTER the volume name had
0769 DC91              *               already been changed by the FST.  This means that the original
0770 DC91              *               pathname had the _new_ volume name used instead of the actual
0771 DC91              *               original volume name.  I've added the rename_preamble routine
0772 DC91              *               that is used by call_fsts PRIOR to calling the FST so that
0773 DC91              *               the REAL original volume name can be determined.
0774 DC91              *
0775 DC91              *       Entry:  jsl
0776 DC91              *
0777 DC91              *       Input:  A = undefined
0778 DC91              *               X = undefined
0779 DC91              *               Y = undefined
0780 DC91              *               P = nvmxdizc
0781 DC91              *                   ..000..x
0782 DC91              *
0783 DC91              *      Output:  A = undefined
0784 DC91              *               X = undefined
0785 DC91              *               Y = undefined
0786 DC91              *               P = nvmxdizc
0787 DC91              *                   ..000..x
0788 DC91              *
0789 DC91              *        Exit:  rtl
0790 DC91              *
0791 DC91              *        Uses:  insert_vol_name
0792 DC91              *
0793 DC91              * Copyright Apple Computer, Inc. 1989  All rights reserved.
0794 DC91              *******************************************************************************
0795 DC91
0796 DC91              rename_preamble Proc 
0797 DC91                       datachk off
0798 DC91 AE CE B9              ldx   path1_v_ptr              ;release any previous translation
0799 DC94 AC D0 B9              ldy   path1_v_ptr+2
0800 DC97 20 41 DD              jsr   release
0801 DC9A 9C CE B9              stz   path1_v_ptr
0802 DC9D 9C D0 B9              stz   path1_v_ptr+2
0803 DCA0              @skip_it  
0804 DCA0
0805 DCA0 9C AE B9              stz   xlate_count              ;Set to pathname 1.
0806 DCA3 AD A2 B9              lda   class                    ;get proper parm offset for this class
0807 DCA6 22 EA F3 00           jsl   xlate_path2_l            ;translate the pathname.
0808 DCAA B0 1E                 bcs   nfg                      ;Return if there is an error.
0809 DCAC 20 4C DD              jsr   insert                   ;convert device name to volume name
0810 DCAF AE CA B9              ldx   v_ptr2
0811 DCB2 AC CC B9              ldy   v_ptr2+2
0812 DCB5 98                    tya   
0813 DCB6 0D CA B9              ora   v_ptr2                   ;was there a conversion?
0814 DCB9 D0 08                 bne   @store_it                ;yes, store the pointer
0815 DCBB AE C6 B9              ldx   v_ptr1                   ;else use pathname as supplied
0816 DCBE AC C8 B9              ldy   v_ptr1+2
0817 DCC1 E2 02                 sep   #2                       ;set Z flag (don't release v_ptr1)
0818 DCC3              @store_it  
0819 DCC3 8E CE B9              stx   path1_v_ptr
0820 DCC6 8C D0 B9              sty   path1_v_ptr+2
0821 DCC9 18                    clc   
0822 DCCA              nfg       
0823 DCCA 6B                    rtl   
0824 DCCB                       datachk on
0825 DCCB
0826 DCCB                       entry Loader_Rename
0827 DCCB              loader_rename  
0828 DCCB                       datachk off
0829 DCCB              *
0830 DCCB              * Re-translate the input paths using xlate_path2 which will not strip off
0831 DCCB              * device names.  Exit if either translation fails...
0832 DCCB              *
0833 DCCB A9 01 00              lda   #1
0834 DCCE 8D AE B9              sta   xlate_count              ;Set to pathname 2.
0835 DCD1 AD A2 B9              lda   class
0836 DCD4 18                    clc   
0837 DCD5 69 04 00              adc   #4                       ;offset to second pathname parameter
0838 DCD8 22 EA F3 00           jsl   xlate_path2_l            ;Translate the pathname.
0839 DCDC B0 62                 bcs   exit2                    ;Exit if error.
0840 DCDE              *
0841 DCDE              * Set data bank to our program bank...
0842 DCDE              *
0843 DCDE 8B                    phb                            ;Save current data bank.
0844 DCDF 4B                    phk                            ;Push program bank.
0845 DCE0 AB                    plb                            ;Set data bank.
0846 DCE1                       datachk on
0847 DCE1              *
0848 DCE1              * Save v_ptr2...
0849 DCE1              *
0850 DCE1 AF CA B9 00           lda   >v_ptr2                  ;Get v_ptr2.
0851 DCE5 8D 58 DE              sta   path2_v_ptr              ;Save it.
0852 DCE8 AF CC B9 00           lda   >v_ptr2+2
0853 DCEC 8D 5A DE              sta   path2_v_ptr+2
0854 DCEF              *
0855 DCEF              * Now insert the volume name if neccessary and push a pointer to the full
0856 DCEF              * pathname as the first parameter for the loader call...
0857 DCEF              *
0858 DCEF AF CE B9 00           lda   >path1_v_ptr             ;get pointer to original name
0859 DCF3 AA                    tax   
0860 DCF4 AF D0 B9 00           lda   >path1_v_ptr+2
0861 DCF8 A8                    tay   
0862 DCF9 22 09 FE 00           jsl   deref2
0863 DCFD 8C 62 DE              sty   old_name+2
0864 DD00 8E 60 DE              stx   old_name
0865 DD03 5A                    phy   
0866 DD04 DA                    phx   
0867 DD05
0868 DD05 A5 3E                 lda   <path2_ptr               ;copy 2nd pathname to path1
0869 DD07 85 3A                 sta   <path1_ptr               ;for the insert call
0870 DD09 A5 40                 lda   <path2_ptr+2
0871 DD0B 85 3C                 sta   <path1_ptr+2
0872 DD0D              *
0873 DD0D              * Now insert the volume name if neccessary and push a pointer to the full
0874 DD0D              * pathname as the second parameter for the loader call...
0875 DD0D              *
0876 DD0D 20 4C DD              jsr   insert                   ;Do insert if needed.
0877 DD10
0878 DD10 D4 3C                 pei   <path1_ptr+2             ;Push path1_ptr (new name).
0879 DD12 D4 3A                 pei   <path1_ptr
0880 DD14              *
0881 DD14              * Now make the loader rename call...
0882 DD14              *
0883 DD14 A2 11 13              ldx   #$1311                   ;Get the tool call #.
0884 DD17 22 00 00 E1           jsl   $E10000                  ;Make the RenamePathname call.
0885 DD1B              *
0886 DD1B              * Now we must walk through all the active FCRs in the system to ensure that
0887 DD1B              * they're all updated with the new pathname.
0888 DD1B              *
0889 DD1B 20 5E DD              jsr   rename_fcrs
0890 DD1E              *
0891 DD1E              * Now release all vp's used...
0892 DD1E              *
0893 DD1E              exit      
0894 DD1E AE 58 DE              ldx   path2_v_ptr              ;Get original v_ptr2.
0895 DD21 AC 5A DE              ldy   path2_v_ptr+2
0896 DD24 20 41 DD              jsr   release                  ;Do release.
0897 DD27
0898 DD27 AE 5C DE              ldx   v_ptr_save_b             ;Get first v_ptr2.
0899 DD2A AC 5E DE              ldy   v_ptr_save_b+2
0900 DD2D 20 41 DD              jsr   release                  ;Do release.
0901 DD30
0902 DD30              ;	v_ptr1 and v_ptr2 are released by call_fsts after return from
0903 DD30              ;	this subroutine
0904 DD30
0905 DD30              *
0906 DD30              * Restore call # and data bank and exit...
0907 DD30              *
0908 DD30                       datachk off
0909 DD30 AB                    plb                            ;Restore data bank.
0910 DD31 AE CE B9              ldx   path1_v_ptr              ;release any previous translation
0911 DD34 AC D0 B9              ldy   path1_v_ptr+2
0912 DD37 20 41 DD              jsr   release
0913 DD3A 9C CE B9              stz   path1_v_ptr
0914 DD3D 9C D0 B9              stz   path1_v_ptr+2
0915 DD40                       datachk on
0916 DD40              exit2     
0917 DD40 6B                    rtl                            ;Exit.
0918 DD41              *
0919 DD41              * Release vp...
0920 DD41              *
0921 DD41 8A           release  txa                            ;Check for null.
0922 DD42 D0 03                 bne   do_it
0923 DD44 98                    tya   
0924 DD45 F0 04                 beq   return                   ;Null!
0925 DD47 22 20 FC 01  do_it    jsl   release_seg              ;Not null.
0926 DD4B 60           return   rts                            ;Exit.
0927 DD4C
0928 DD4C              *
0929 DD4C              * Set data bank register to code bank of call, call insert_vol_name and restore
0930 DD4C              * data bank...
0931 DD4C              *
0932 DD4C                       DATACHK OFF
0933 DD4C 8B           insert   phb                            ;Save program bank.
0934 DD4D F4 B4 00              pea   insert_vol_name>>8       ;Get bank word.
0935 DD50 AB                    plb                            ;Set data bank.
0936 DD51 AB                    plb                            ;(twice 'cuz did pea).
0937 DD52 9C CA B9              stz   v_ptr2
0938 DD55 9C CC B9              stz   v_ptr2+2
0939 DD58 22 7D B4 00           jsl   insert_vol_name          ;Do call.
0940 DD5C AB                    plb                            ;Restore data bank.
0941 DD5D 60                    rts                            ;Exit to caller.
0942 DD5E                       DATACHK ON
0943 DD5E
0944 DD5E              rename_fcrs  
0945 DD5E              *
0946 DD5E              * path1_ptr is left over from the second insert call and points to the new pathname
0947 DD5E              * old_name was saved after the first insert call and contains a pointer to the
0948 DD5E              *   original pathname
0949 DD5E              *
0950 DD5E              old_name_ptr equ   path2_ptr            ;alias for pointer to old pathname
0951 DD5E              new_name_ptr equ   path1_ptr            ;alias for pointer to new pathname
0952 DD5E              fcr_ptr_temp equ   s_temp1              ;pointer to fcr
0953 DD5E              fcr_name_vp equ   s_temp2               ;vp of original fcr name
0954 DD5E              fcr_name equ   s_temp3                  ;pointer to fcr name
0955 DD5E              temp_vp  equ   s_temp4                  ;temporary vp used to build new pathname
0956 DD5E              temp_name_ptr equ   s_temp5             ;temp pointer used to build new pathname
0957 DD5E
0958 DD5E              ; These variables reside in the fst workspace.  Since we won't be calling any FSTs, and
0959 DD5E              ; all FSTs share the workspace (meaning that no FST can depend on any value in the
0960 DD5E              ; workspace being static), we should be able to use the memory safely.
0961 DD5E
0962 DD5E              remainder equ   fst_start               ;remainder of FCR's pathname after matching prefix
0963 DD5E              old_index equ   remainder+2
0964 DD5E              new_index equ   old_index+2
0965 DD5E              terminate equ   new_index+2
0966 DD5E              fst_id_temp equ   terminate+2           ;fst id of fst that handled ChangePath call
0967 DD5E              fcr_count equ   fst_id_temp+2           ;index to current fcr
0968 DD5E
0969 DD5E AD 60 DE              lda   old_name                 ;retrieve pointer to original pathname
0970 DD61 85 3E                 sta   <old_name_ptr
0971 DD63 AD 62 DE              lda   old_name+2
0972 DD66 85 40                 sta   <old_name_ptr+2
0973 DD68
0974 DD68 64 8A                 stz   fcr_count                ;init fcr index
0975 DD6A AF 15 B9 00           lda   >curr_fst                ;get id of fst that handled call
0976 DD6E AA                    tax   
0977 DD6F BF 1D B8 00           lda   >fst_tbl+id,x
0978 DD73 85 88                 sta   fst_id_temp              ;save for comparisons
0979 DD75
0980 DD75              fcr_loop  
0981 DD75 E6 8A                 inc   fcr_count                ;step to next fcr
0982 DD77 A5 8A                 lda   fcr_count
0983 DD79 22 64 FC 01           jsl   get_fcr                  ;get vp to next fcr
0984 DD7D B0 74                 bcs   @to_fcr_exit             ;no more fcr's, we're done
0985 DD7F 22 09 FE 00           jsl   deref2                   ;turn into real pointer
0986 DD83 86 D4                 stx   fcr_ptr_temp
0987 DD85 84 D6                 sty   fcr_ptr_temp+2
0988 DD87 A0 06 00              ldy   #fcr_fst_id              ;does the fcr belong to the fst that
0989 DD8A B7 D4                 lda   [fcr_ptr_temp],y         ; handled the call?
0990 DD8C C5 88                 cmp   fst_id_temp
0991 DD8E D0 E5                 bne   fcr_loop                 ;no, skip this fcr
0992 DD90 A0 02 00              ldy   #fcr_path_name           ;else get pointer to pathname
0993 DD93 B7 D4                 lda   [fcr_ptr_temp],y
0994 DD95 85 D8                 sta   fcr_name_vp              ;save VP for disposal if we rename this one
0995 DD97 AA                    tax   
0996 DD98 C8                    iny   
0997 DD99 C8                    iny   
0998 DD9A B7 D4                 lda   [fcr_ptr_temp],y
0999 DD9C 85 DA                 sta   fcr_name_vp+2
1000 DD9E A8                    tay   
1001 DD9F 22 09 FE 00           jsl   deref2                   ;turn into a real pointer
1002 DDA3 86 DC                 stx   fcr_name
1003 DDA5 84 DE                 sty   fcr_name+2
1004 DDA7 A7 DC                 lda   [fcr_name]               ;get length of fcr pathname
1005 DDA9 C7 3E                 cmp   [old_name_ptr]           ;shorter than original pathname parameter?
1006 DDAB 90 C8                 bcc   fcr_loop                 ;yes, can't possibly be a match
1007 DDAD A7 3E                 lda   [old_name_ptr]           ;get length of original name
1008 DDAF 1A                    inc   a                        ;account for leading length word
1009 DDB0 1A                    inc   a
1010 DDB1 A8                    tay                            ;into index
1011 DDB2 E2 20                 sep   #$20                     ;8-bit comparison
1012 DDB4                       longa off
1013 DDB4 B7 DC                 lda   [fcr_name],y             ;get character after prefix
1014 DDB6 C9 3A                 cmp   #sep                     ;MUST be a separator character
1015 DDB8 F0 04                 beq   @maybe                   ;so far, so good
1016 DDBA              @not_this_one  
1017 DDBA C2 20                 rep   #$20                     ;back to 16-bit accumulator
1018 DDBC 80 B7                 bra   fcr_loop
1019 DDBE              @maybe    
1020 DDBE 88                    dey                            ;skip back to last character of prefix
1021 DDBF              @name_loop  
1022 DDBF B7 3E                 lda   [old_name_ptr],y         ;get a character
1023 DDC1 57 DC                 eor   [fcr_name],y             ;case-insensitive comparison
1024 DDC3 F0 16                 beq   @equal                   ;same character!
1025 DDC5 C9 20                 cmp   #$20                     ;only a difference in case?
1026 DDC7 D0 F1                 bne   @not_this_one            ;nope!
1027 DDC9 B7 3E                 lda   [old_name_ptr],y         ;get the character again
1028 DDCB C9 41                 cmp   #'A'                     ;make sure it's alphabetic
1029 DDCD 90 EB                 bcc   @not_this_one
1030 DDCF C9 5B                 cmp   #'Z'+1
1031 DDD1 90 08                 bcc   @equal                   ;yup, it was uppercase
1032 DDD3 C9 61                 cmp   #'a'                     ;possibly lower case?
1033 DDD5 90 E3                 bcc   @not_this_one            ;no...
1034 DDD7 C9 7B                 cmp   #'z'+1
1035 DDD9 B0 DF                 bcs   @not_this_one            ;no way!
1036 DDDB              @equal    
1037 DDDB 88                    dey                            ;step back to previous character
1038 DDDC C0 02 00              cpy   #$0002                   ;done all characters yet?
1039 DDDF B0 DE                 bcs   @name_loop               ;loop through whole name
1040 DDE1 C2 20                 rep   #$20
1041 DDE3                       longa on
1042 DDE3
1043 DDE3              ; We have found a match.  Now we have to rename the fcr, using the new pathname plus
1044 DDE3              ; that portion of the original fcr name that extends beyond the end of the prefix
1045 DDE3
1046 DDE3 A7 DC                 lda   [fcr_name]               ;get original length
1047 DDE5 38                    sec   
1048 DDE6 E7 3E                 sbc   [old_name_ptr]           ;calculate length of name beyond prefix
1049 DDE8 85 80                 sta   remainder                ;remember this for later
1050 DDEA 67 3A                 adc   [new_name_ptr]           ;calc total length of new name (+1 -carry's set)
1051 DDEC 1A                    inc   a                        ;allow for leading length word
1052 DDED 1A                    inc   a                        ;and trailing null
1053 DDEE 38                    sec                            ;zero it (to generate trailing null)
1054 DDEF 22 E8 FC 00           jsl   alloc_zero               ;get some memory for the new name
1055 DDF3 B0 62        @to_fcr_exit bcs   fcr_exit             ;out of memory!                                               
1056 DDF5 86 E0                 stx   temp_vp                  ;save the vp for later
1057 DDF7 84 E2                 sty   temp_vp+2
1058 DDF9 22 09 FE 00           jsl   deref2                   ;make into a real pointer
1059 DDFD 86 E4                 stx   temp_name_ptr
1060 DDFF 84 E6                 sty   temp_name_ptr+2
1061 DE01 86 E8                 stx   ptr                      ;set up for copy call
1062 DE03 84 EA                 sty   ptr+2
1063 DE05 A5 3A                 lda   new_name_ptr
1064 DE07 85 EC                 sta   m_temp
1065 DE09 A5 3C                 lda   new_name_ptr+2
1066 DE0B 85 EE                 sta   m_temp+2
1067 DE0D 22 18 B7 00           jsl   to_copy_string           ;copy the new prefix in
1068 DE11 A7 3E                 lda   [old_name_ptr]           ;get length of original name
1069 DE13 1A                    inc   a                        ;leading length word
1070 DE14 1A                    inc   a
1071 DE15 85 82                 sta   old_index                ;this indexes the remainder of the fcr's name
1072 DE17 A8                    tay                            ;for later
1073 DE18 A7 E4                 lda   [temp_name_ptr]          ;get length of prefix
1074 DE1A AA                    tax                            ;save for a sec
1075 DE1B 1A                    inc   a                        ;adjust for length word
1076 DE1C 1A                    inc   a
1077 DE1D 85 84                 sta   new_index                ;this indexes the concatenation location
1078 DE1F 8A                    txa                            ;retrieve real length
1079 DE20 18                    clc                            ;calculate new length
1080 DE21 65 80                 adc   remainder
1081 DE23 87 E4                 sta   [temp_name_ptr]
1082 DE25 A7 DC                 lda   [fcr_name]               ;get length of original name
1083 DE27 1A                    inc   a
1084 DE28 1A                    inc   a
1085 DE29 85 86                 sta   terminate                ;store as terminating value
1086 DE2B E2 20                 sep   #$20
1087 DE2D                       longa off
1088 DE2D B7 DC        @concat  lda   [fcr_name],y             ;get a character
1089 DE2F A4 84                 ldy   new_index
1090 DE31 97 E4                 sta   [temp_name_ptr],y        ;store into new pathname
1091 DE33 E6 82                 inc   old_index                ;bump indexes
1092 DE35 E6 84                 inc   new_index
1093 DE37 A4 82                 ldy   old_index                ;done whole name yet?
1094 DE39 C4 86                 cpy   terminate
1095 DE3B 90 F0                 bcc   @concat                  ;no, loop until at end
1096 DE3D C2 20                 rep   #$20
1097 DE3F                       longa on
1098 DE3F
1099 DE3F A0 02 00              ldy   #fcr_path_name           ;store vp of new pathname
1100 DE42 A5 E0                 lda   temp_vp
1101 DE44 97 D4                 sta   [fcr_ptr_temp],y
1102 DE46 C8                    iny   
1103 DE47 C8                    iny   
1104 DE48 A5 E2                 lda   temp_vp+2
1105 DE4A 97 D4                 sta   [fcr_ptr_temp],y
1106 DE4C
1107 DE4C A6 D8                 ldx   fcr_name_vp              ;dispose of the original name
1108 DE4E A4 DA                 ldy   fcr_name_vp+2
1109 DE50 22 15 FD 00           jsl   deallocate
1110 DE54
1111 DE54 4C 75 DD              jmp   fcr_loop                 ;go back and do the next one
1112 DE57
1113 DE57 60           fcr_exit rts   
1114 DE58
1115 DE58              *
1116 DE58              * Storage area for v_ptrs...
1117 DE58              *
1118 DE58 00 00 00 00  path2_v_ptr DC L:00000000               ;Original v_ptr2.
1119 DE5C 00 00 00 00  v_ptr_save_b DC L:00000000              ;First v_ptr2.
1120 DE60 00 00 00 00  old_name DS L:1                         ;original pathname (translated)
1121 DE64
1122 DE64                       end_proc 
1123 DE64
1124 DE64                       Eject 
1125 DE64              ;===============================================================================
1126 DE64              ;
1127 DE64              ; do_insert_scan - System Service Vector handler which allows a module external
1128 DE64              ; to the OS to perform a device scan looking for a disk insertion.  This
1129 DE64              ; procedure saves the callers DBR and DP registers, sets these registers to
1130 DE64              ; those needed by the OS routines, and then performs the device scan.  On exit,
1131 DE64              ; the caller's DBR and DP will be restored, and the carry will be conditioned
1132 DE64              ; according to what happened during the scan.  If the carry is set, no insertion
1133 DE64              ; was seen.  If the carry is clear, the Accumulator will contain the device
1134 DE64              ; number of the first device that had a disk inserted.
1135 DE64              ;
1136 DE64              ; On entry, it is assumed that the language card memory is banked in
1137 DE64              ; properly (otherwise, it won't ever get here), and that the processor is in
1138 DE64              ; full native mode.
1139 DE64              ;
1140 DE64              ;===============================================================================
1141 DE64
1142 DE64              do_insert_scan Proc 
1143 DE64                       DataChk Off
1144 DE64
1145 DE64              ; save the caller's environment
1146 DE64 8B                    phb                            ;save DBR
1147 DE65 0B                    phd                            ;save direct page
1148 DE66 F4 D5 00              pea   gsos_lc_entry>>8         ;set DBR to our normal data bank
1149 DE69 AB                    plb   
1150 DE6A AB                    plb   
1151 DE6B A9 00 BD              lda   #direct_base             ;set DP to our direct page
1152 DE6E 5B                    tcd   
1153 DE6F
1154 DE6F A9 00 00              lda   #$0000                   ;init device number
1155 DE72 48                    pha                            ;and return device #
1156 DE73 48                    pha   
1157 DE74              scan_loop  
1158 DE74 68                    pla                            ;retrieve device #
1159 DE75 1A                    inc   a                        ;bump by 1
1160 DE76 48                    pha                            ;put back on stack
1161 DE77 85 04                 sta   <drvr_buf_ptr            ;put here for device dispatcher
1162 DE79 64 00                 stz   <drvr_dev_num            ;we want to talk to dispatcher
1163 DE7B A9 01 00              lda   #get_dib_ptr             ;return the driver dib pointer
1164 DE7E 85 02                 sta   <drvr_call_num
1165 DE80 22 00 FC 01           jsl   dev_dispatcher
1166 DE84 B0 38                 bcs   exit                     ;exit if error occurs
1167 DE86
1168 DE86 A0 08 00              ldy   #dev_char                ;get the characteristics
1169 DE89 B7 20                 lda   [<drvr_dib_ptr],y
1170 DE8B 89 80 00              bit   #%0000000010000000       ;block device?
1171 DE8E F0 E4                 beq   scan_loop                ;no...
1172 DE90 89 04 00              bit   #%0000000000000100       ;removeable media?
1173 DE93 F0 DF                 beq   scan_loop                ;no...
1174 DE95 A0 34 00              ldy   #dev_id_num              ;get the device ID
1175 DE98 B7 20                 lda   [<drvr_dib_ptr],y
1176 DE9A F0 D8                 beq   scan_loop                ;ignore Disk ]['s
1177 DE9C              *	cmp	#$0006	;and SCSI tape drives
1178 DE9C              *	beq	scan_loop
1179 DE9C              *	cmp	#$0015	;and generic tape drives
1180 DE9C              *	beq	scan_loop
1181 DE9C C9 20 00              cmp   #$0020                   ;and Apple SCSI tape drives
1182 DE9F F0 D3                 beq   scan_loop
1183 DEA1
1184 DEA1 A3 01                 lda   1,s                      ;get the device number again
1185 DEA3 20 26 DB              jsr   do_drvr_status           ;get status on this device
1186 DEA6 B0 16                 bcs   exit                     ;punt if we get an error
1187 DEA8 AF DC B9 00           lda   >dev_status              ;get the status word
1188 DEAC 29 11 00              and   #%0000000000010001       ;check for disk switched & online
1189 DEAF C9 11 00              cmp   #%0000000000010001       ;is that the status?
1190 DEB2 D0 C0                 bne   scan_loop                ;no, try next device
1191 DEB4 A3 03                 lda   3,s                      ;have we already seen an insertion?
1192 DEB6 D0 BC                 bne   scan_loop                ;yup, leave it as-is
1193 DEB8 A3 01                 lda   1,s                      ;get the device # again
1194 DEBA 83 03                 sta   3,s                      ;and copy into local variable
1195 DEBC 80 B6                 bra   scan_loop                ;loop until all devices looked at
1196 DEBE
1197 DEBE FA           exit     plx                            ;clean up stack
1198 DEBF 68                    pla                            ;retrieve device # that had insertion
1199 DEC0 F0 01                 beq   @bye_bye                 ;if non-zero, we had an insertion
1200 DEC2 18                    clc                            ;else signal that we saw an insertion
1201 DEC3              @bye_bye  
1202 DEC3
1203 DEC3              ; restore the caller's environment
1204 DEC3 2B                    pld                            ;restore DP
1205 DEC4 AB                    plb                            ;restore DBR
1206 DEC5 6B                    rtl                            ;and back to system
1207 DEC6
1208 DEC6                       DataChk On
1209 DEC6                       end_proc 
1210 DEC6
1211 DEC6                       eject 
1212 DEC6              *******************************************************************************
1213 DEC6              *
1214 DEC6              *        Name:  do_alert_window
1215 DEC6              *
1216 DEC6              * Description:  Replaces $8D's in alert string with spaces, calls AlertWindow,
1217 DEC6              *               then restores $8D's.
1218 DEC6              *
1219 DEC6              *      Author:  Bryan Atsatt
1220 DEC6              *     Created:  May 18, 1989
1221 DEC6              *    Modified:
1222 DEC6              *
1223 DEC6              *       Entry:  jsl
1224 DEC6              *
1225 DEC6              *       Input:  A = undefined
1226 DEC6              *               X = undefined
1227 DEC6              *               Y = undefined
1228 DEC6              *               P = nvmxdizc
1229 DEC6              *                   ..000..x
1230 DEC6              *
1231 DEC6              *      Output:  A = undefined
1232 DEC6              *               X = undefined
1233 DEC6              *               Y = undefined
1234 DEC6              *               P = nvmxdizc
1235 DEC6              *                   ..000..x
1236 DEC6              *
1237 DEC6              *        Exit:  rtl
1238 DEC6              *
1239 DEC6              *        Uses:  insert_vol_name
1240 DEC6              *
1241 DEC6              * Copyright Apple Computer, Inc. 1989  All rights reserved.
1242 DEC6              *******************************************************************************
1243 DEC6
1244 DEC6              cr       equ   $8d
1245 DEC6              space    equ   $20
1246 DEC6                       DataChk Off
1247 DEC6
1248 DEC6              do_alert_window proc 
1249 DEC6
1250 DEC6              *
1251 DEC6              * Replace $8D's with $20's in alert string, saving offsets on stack...
1252 DEC6              *
1253 DEC6                       longa off
1254 DEC6 E2 20                 sep   #$20                     ;Go to 8 bit A.
1255 DEC8
1256 DEC8 A2 00 00              ldx   #0                       ;Init counter.
1257 DECB A0 FF FF              ldy   #$ffff                   ;Init offset.
1258 DECE
1259 DECE C8           replace_loop iny   
1260 DECF B7 13                 lda   [<alert_ptr],y           ;Get byte. Reached end?
1261 DED1 F0 0C                 beq   save_count               ;Yep.
1262 DED3 C9 8D                 cmp   #cr                      ;Nope, is cr?
1263 DED5 D0 F7                 bne   replace_loop             ;Nope, so continue.
1264 DED7 5A                    phy                            ;Yes, save offset.
1265 DED8 E8                    inx                            ;Bump counter.
1266 DED9 A9 20                 lda   #space                   ;Replace with space.
1267 DEDB 97 13                 sta   [<alert_ptr],y
1268 DEDD 80 EF                 bra   replace_loop             ;Do next character.
1269 DEDF
1270 DEDF DA           save_count phx                          ;Save count.
1271 DEE0
1272 DEE0                       longa on                       ;Restore 16 bit A.
1273 DEE0 C2 20                 rep   #$20
1274 DEE2
1275 DEE2              *
1276 DEE2              * Do the AlertWindow call...
1277 DEE2              *
1278 DEE2 48                    pha                            ;push space for response
1279 DEE3 F4 61 00              pea   $0061                    ;push indicator that substitution
1280 DEE6                                                      	 ;...strings are Pascal strings
1281 DEE6 D4 19                 pei   <subst_ptr+2             ;push pointer to substitution string
1282 DEE8 D4 17                 pei   <subst_ptr               ;...table
1283 DEEA
1284 DEEA D4 15                 pei   <alert_ptr+2             ;push pointer to alert string
1285 DEEC D4 13                 pei   <alert_ptr
1286 DEEE
1287 DEEE A2 0E 59              ldx   #$590E                   ;call the AlertWindow tool
1288 DEF1 22 00 00 E1           jsl   $E10000
1289 DEF5 68                    pla                            ;pull response off stack--save in Y
1290 DEF6 8F 0F DF E1           sta   >save_y                  ;Save it.
1291 DEFA              *
1292 DEFA              * Restore string and exit...
1293 DEFA              *
1294 DEFA FA                    plx                            ;Recover count.
1295 DEFB F0 0C                 beq   exit                     ;Exit if null.
1296 DEFD
1297 DEFD                       longa off
1298 DEFD E2 20                 sep   #$20                     ;Go to 8 bit A.
1299 DEFF
1300 DEFF 7A           restore_loop ply                        ;Recover offset.
1301 DF00 A9 8D                 lda   #cr                      ;Restore cr.
1302 DF02 97 13                 sta   [<alert_ptr],y
1303 DF04 CA                    dex                            ;Done all?
1304 DF05 D0 F8                 bne   restore_loop             ;Nope, so loop.
1305 DF07
1306 DF07                       longa on                       ;Restore 16 bit A.
1307 DF07 C2 20                 rep   #$20
1308 DF09
1309 DF09 AF 0F DF E1  exit     lda   >save_y                  ;Recover Y.
1310 DF0D A8                    tay   
1311 DF0E 6B                    rtl                            ;Exit
1312 DF0F
1313 DF0F 00 00        save_y   DC W:0000                      ;Storage.
1314 DF11
1315 DF11                       end_proc 
1316 DF11                       DataChk On
1317 DF11
1318 DF11                       eject 
1319 DF11              ;===============================================================================
1320 DF11              ; s_mount_msg
1321 DF11              ;
1322 DF11              ; Write out the internationalized mount volume message.
1323 DF11              ;
1324 DF11              ; Created:      1/12/88
1325 DF11              ; Modified:     1/23/88 (mikie)
1326 DF11              ; Author:       JJ
1327 DF11              ;
1328 DF11              ; Input:        pointer to volume name to be written out in message
1329 DF11              ;        S --->
1330 DF11              ;
1331 DF11              ;               A = $0000: use sys_prefs, $0001: force dialog
1332 DF11              ;               P = nvmxdizc
1333 DF11              ;                   ..000...
1334 DF11              ;
1335 DF11              ; Output:       A = response indicating which button was pressed
1336 DF11              ;               X = trashed
1337 DF11              ;               Y = trashed
1338 DF11              ;               P = nvmxdizc
1339 DF11              ;                   ..000...
1340 DF11              ;===============================================================================
1341 DF11
1342 DF11                       DATACHK OFF 
1343 DF11              s_mount_msg proc 
1344 DF11
1345 DF11              ; The mount message is displayed only under certain conditions.  The FST
1346 DF11              ;  can mandate the appearance of the message by calling with an Acc value of
1347 DF11              ;  A=$0001.  If A=$0000 the appearance of the box is dictated by the App
1348 DF11              ;  preference word (msb) which is set or reset by the Set_Sys_Prefs call.
1349 DF11
1350 DF11 4A                    lsr   a
1351 DF12 B0 15                 bcs   doit                     ;Force the message
1352 DF14
1353 DF14 AF F6 B9 00           lda   >sys_prefs               ;In this case let the preference decide
1354 DF18 30 0F                 bmi   doit                     ;If msb then continue with the box
1355 DF1A
1356 DF1A A3 01                 lda   1,s                      ;Squeeze input parms out of stack
1357 DF1C 83 05                 sta   5,s
1358 DF1E A3 02                 lda   2,s
1359 DF20 83 06                 sta   6,s
1360 DF22 68                    pla   
1361 DF23 68                    pla   
1362 DF24
1363 DF24 A9 01 00              lda   #$0001                   ;Make it look like the User cancelled
1364 DF27 18                    clc   
1365 DF28 6B                    rtl   
1366 DF29
1367 DF29
1368 DF29              doit      
1369 DF29              ;
1370 DF29              ; Make stack space for additional parameters.
1371 DF29              ;
1372 DF29 48                    pha   
1373 DF2A              ;
1374 DF2A              ; Move substitution string pointers from stack into fixed table.
1375 DF2A              ;
1376 DF2A A3 06                 lda   6,s                      ;low word of substitution string pointer
1377 DF2C 8F EC ED 00           sta   >sub_ptr_1
1378 DF30 A3 08                 lda   8,s                      ;high word of substitution string ptr
1379 DF32 8F EE ED 00           sta   >sub_ptr_1+2
1380 DF36              ;
1381 DF36              ; Move return address upward by 4 bytes.
1382 DF36              ;
1383 DF36 A3 03                 lda   3,s                      ;low word
1384 DF38 83 07                 sta   7,s
1385 DF3A A3 04                 lda   4,s                      ;middle word
1386 DF3C 83 08                 sta   8,s
1387 DF3E              ;
1388 DF3E              ; Insert error number into the appropriate parameter position.  We select the message
1389 DF3E              ; number based on bit 14 of the sys_prefs word...
1390 DF3E              ;
1391 DF3E A2 01 00              ldx   #mount_msg_num1          ;Init to default message.
1392 DF41 AF F6 B9 00           lda   >sys_prefs               ;Use alternate?
1393 DF45 29 00 40              and   #%0100000000000000
1394 DF48 F0 03                 beq   use_default              ;Nope.
1395 DF4A A2 2E 00              ldx   #mount_msg_num2          ;Yes.
1396 DF4D 8A           use_default txa   
1397 DF4E 83 05                 sta   5,s
1398 DF50              ;
1399 DF50              ; Place pointer to substitution string table into parameter position.
1400 DF50              ;
1401 DF50 A9 EC ED              lda   #sub_ptr_1               ;low word
1402 DF53 83 01                 sta   1,s
1403 DF55 A9 00 00              lda   #sub_ptr_1>>16           ;high word
1404 DF58 83 03                 sta   3,s
1405 DF5A              ;
1406 DF5A              ; set the flag so that devices are scanned for a disk insertion
1407 DF5A              ;
1408 DF5A A9 01 00              lda   #1
1409 DF5D 8F DE B9 00           sta   >do_runq                 ;use the runq handler
1410 DF61              ;
1411 DF61              ; set up to do a SysBeep at the next GetNextEvent call
1412 DF61              ;
1413 DF61 F4 30 40              pea   $4030                    ;Disk Request beep
1414 DF64 A2 03 38              ldx   #$3803                   ;SysBeep2
1415 DF67 22 00 00 E1           jsl   $E10000
1416 DF6B              *** added 12-Aug-92 DAL -- Clean up stack on error.
1417 DF6B 90 01                 bcc   @stack_ok                ;assume only error is from tool dispatcher
1418 DF6D 68                    pla                            ;pull input parameter
1419 DF6E              @stack_ok  
1420 DF6E              *** end 12-Aug-92
1421 DF6E              ;
1422 DF6E              ; Finally call full_error.
1423 DF6E              ;
1424 DF6E 22 4C F0 00           jsl   s_full_error
1425 DF72
1426 DF72 AA                    tax                            ;save the return value
1427 DF73 A9 00 00              lda   #0
1428 DF76 8F DE B9 00           sta   >do_runq                 ;don't use runq handler
1429 DF7A 8A                    txa                            ;restore return value
1430 DF7B 18                    clc   
1431 DF7C 6B                    rtl   
1432 DF7D
1433 DF7D                       end_proc 
1434 DF7D                       DATACHK ON 
1435 DF7D                       eject 
1436 DF7D              ;======================================================================
1437 DF7D              ; getkey : Wait for a keypress
1438 DF7D              ;
1439 DF7D              ;Created:       January 12, 1988
1440 DF7D              ;Modified:      January 12, 1988
1441 DF7D              ;Author:        Mike Askins
1442 DF7D              ;
1443 DF7D              ;Copyright Apple Computer Inc. 1987-8  All rights reserved
1444 DF7D              ;
1445 DF7D              ;Input:         A = <undefined>
1446 DF7D              ;               X = <undefined>
1447 DF7D              ;               Y = <undefined>
1448 DF7D              ;               P = nvmxdizc
1449 DF7D              ;                   ..x00...
1450 DF7D              ;
1451 DF7D              ;Output:        A = Key pressed (msb off)
1452 DF7D              ;               X = <trashed>
1453 DF7D              ;               Y = <trashed>
1454 DF7D              ;               P = nvmxdizc
1455 DF7D              ;                   ..x00...
1456 DF7D              ;               b = preserved
1457 DF7D              ;
1458 DF7D              ;======================================================================
1459 DF7D
1460 DF7D              getkey   proc 
1461 DF7D                       DataChk off
1462 DF7D
1463 DF7D 08                    php   
1464 DF7E C2 30                 rep   #$30                     ;Force 16 bit acc
1465 DF80                       longa on
1466 DF80                       longi on
1467 DF80
1468 DF80              getkey1   
1469 DF80 AD DE B9              lda   do_runq                  ;do we need to do a device scan?
1470 DF83 F0 1B                 beq   @no_scan                 ;no...
1471 DF85
1472 DF85 48                    pha                            ;space for result
1473 DF86 48                    pha   
1474 DF87 A2 03 25              ldx   #$2503                   ;GetTick
1475 DF8A 22 00 00 E1           jsl   $E10000
1476 DF8E 68                    pla                            ;retrieve tick count
1477 DF8F FA                    plx                            ;(high word not used)
1478 DF90 29 3F 00              and   #63                      ;do a MOD 64
1479 DF93 D0 0B                 bne   @no_scan                 ;do device scan every 64th tick
1480 DF95 22 64 DE E1           jsl   do_insert_scan           ;(close enough to call it every second)
1481 DF99 B0 05                 bcs   @no_scan                 ;no insert this time!
1482 DF9B A9 5A A5              lda   #$A55A                   ;special code to signal a disk insertion
1483 DF9E 28                    plp                            ;restore register size
1484 DF9F 6B                    rtl   
1485 DFA0
1486 DFA0              @no_scan  
1487 DFA0 48                    pha                            ;Space for result
1488 DFA1 A9 28 04              lda   #$0428                   ;event mask
1489 DFA4 48                    pha   
1490 DFA5 F4 E1 00              pea   the_event>>16            ;pointer to event record
1491 DFA8 F4 D2 DF              pea   the_event
1492 DFAB A2 06 0A 22           _GetNextEvent 
1493 DFB2 68                    pla   
1494 DFB3 B0 08                 bcs   read_myself
1495 DFB5
1496 DFB5 F0 C9                 beq   getkey1                  ;Nothing interesting...
1497 DFB7 AF D4 DF E1           lda   >evt_message
1498 DFBB 80 10                 bra   gotkey
1499 DFBD
1500 DFBD              read_myself  
1501 DFBD E2 20                 sep   #$20                     ;Force 8 bit mode
1502 DFBF AF 00 C0 E0           lda   >$E0C000                 ;do we have a keypress?
1503 DFC3 10 04                 bpl   nokey                    ;no...
1504 DFC5 8F 10 C0 E0           sta   >$E0C010                 ;yes!  clear the strobe
1505 DFC9              nokey     
1506 DFC9 C2 20                 rep   #$20                     ;back to 16-bit accumulator
1507 DFCB 10 B3                 bpl   getkey1
1508 DFCD
1509 DFCD              gotkey    
1510 DFCD 29 7F 00              and   #$007F                   ;clear high byte and bit 7 of character
1511 DFD0 28                    plp                            ;Restore reg size mode
1512 DFD1
1513 DFD1 6B                    rtl   
1514 DFD2
1515 DFD2              the_event  
1516 DFD2 00 00        evt_what DC W:0
1517 DFD4 00 00 00 00  evt_message DC L:0
1518 DFD8 00 00 00 00  evt_when DC L:0
1519 DFDC 00 00 00 00  evt_where DC L:0
1520 DFE0 00 00        evt_mod  DC W:0
1521 DFE2
1522 DFE2                       DataChk On
1523 DFE2                       end_proc 
1524 DFE2                       eject 
1525 DFE2              *******************************************************************************
1526 DFE2              * Another storage area
1527 DFE2              *******************************************************************************
1528 DFE2
1529 DFE2              more_storage proc 
1530 DFE2                       entry vidtab
1531 DFE2
1532 DFE2              *
1533 DFE2              * The following table contains the starting addresses for text screen lines
1534 DFE2              * 6-19 for the routine gotoxy...
1535 DFE2              *
1536 DFE2              vidtab    
1537 DFE2 00 07                 DC W:$0700                     ;Line 6
1538 DFE4 80 07                 DC W:$0780                     ;Line 7
1539 DFE6 28 04                 DC W:$0428                     ;Line 8
1540 DFE8 A8 04                 DC W:$04A8                     ;Line 9
1541 DFEA 28 05                 DC W:$0528                     ;Line 10
1542 DFEC A8 05                 DC W:$05A8                     ;Line 11
1543 DFEE 28 06                 DC W:$0628                     ;Line 12
1544 DFF0 A8 06                 DC W:$06A8                     ;Line 13
1545 DFF2 28 07                 DC W:$0728                     ;Line 14
1546 DFF4 A8 07                 DC W:$07A8                     ;Line 15
1547 DFF6 50 04                 DC W:$0450                     ;Line 16
1548 DFF8 D0 04                 DC W:$04D0                     ;Line 17
1549 DFFA 50 05                 DC W:$0550                     ;Line 18
1550 DFFC D0 05                 DC W:$05D0                     ;Line 19
1551 DFFE
1552 DFFE                       end_proc 
1553 DFFE                       eject 
1554 DFFE              *******************************************************************************
1555 DFFE              *
1556 DFFE              * End bank_e1 segment: $E1D980-E1DFFF
1557 DFFE              *
1558 DFFE              *******************************************************************************
